/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.net;

import java.util.Objects;
import javax.annotation.Nullable;
import net.createmod.catnip.config.ui.ConfigHelper;
import net.createmod.catnip.net.ServerboundPacket;
import net.createmod.ponder.Ponder;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ServerboundConfigPacket<T>
implements ServerboundPacket {
    public static final class_2960 ID = Ponder.asResource("config_packet");
    private final String modID;
    private final String path;
    private final String value;

    public ServerboundConfigPacket(String modID, String path, T value) {
        this.modID = Objects.requireNonNull(modID);
        this.path = path;
        this.value = this.serialize(value);
    }

    public ServerboundConfigPacket(class_2540 buffer) {
        this.modID = buffer.method_10800(Short.MAX_VALUE);
        this.path = buffer.method_10800(Short.MAX_VALUE);
        this.value = buffer.method_10800(Short.MAX_VALUE);
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10814(this.modID);
        buffer.method_10814(this.path);
        buffer.method_10814(this.value);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public void handle(@Nullable MinecraftServer server, @Nullable class_3222 player) {
        if (server == null || player == null) {
            Ponder.LOGGER.error("Unable to handle ConfigureConfig Packet. Player ({}) or Server ({}) was null!", (Object)player, (Object)server);
            return;
        }
        server.execute(() -> {
            try {
                ForgeConfigSpec.ConfigValue configValue;
                Object v;
                if (!player.method_5687(2)) {
                    return;
                }
                ForgeConfigSpec spec = ConfigHelper.findForgeConfigSpecFor(ModConfig.Type.SERVER, this.modID);
                if (spec == null) {
                    return;
                }
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(this.path);
                if (!valueSpec.test(v = ServerboundConfigPacket.deserialize((configValue = (ForgeConfigSpec.ConfigValue)spec.getValues().get(this.path)).get(), this.value))) {
                    return;
                }
                configValue.set(v);
            }
            catch (Exception e) {
                Ponder.LOGGER.warn("Unable to handle ConfigureConfig Packet. ", (Throwable)e);
            }
        });
    }

    public String serialize(T value) {
        if (value instanceof Boolean) {
            return Boolean.toString((Boolean)value);
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        if (value instanceof Float) {
            return Float.toString(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return Double.toString((Double)value);
        }
        throw new IllegalArgumentException("unknown type " + value + ": " + value.getClass().getSimpleName());
    }

    public static Object deserialize(Object type, String sValue) {
        if (type instanceof Boolean) {
            return Boolean.parseBoolean(sValue);
        }
        if (type instanceof Enum) {
            return Enum.valueOf(((Enum)type).getClass(), sValue);
        }
        if (type instanceof Integer) {
            return Integer.parseInt(sValue);
        }
        if (type instanceof Float) {
            return Float.valueOf(Float.parseFloat(sValue));
        }
        if (type instanceof Double) {
            return Double.parseDouble(sValue);
        }
        throw new IllegalArgumentException("unknown type " + type + ": " + type.getClass().getSimpleName());
    }
}

